/*
 * Decompiled with CFR 0.152.
 */
package com.lycanitesmobs.core.spawning;

import com.lycanitesmobs.ExtendedWorld;
import com.lycanitesmobs.LycanitesMobs;
import com.lycanitesmobs.core.config.ConfigBase;
import com.lycanitesmobs.core.spawning.CustomSpawner;
import com.lycanitesmobs.core.spawning.SpawnTypeBase;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.translation.I18n;
import net.minecraft.world.World;

public class SpawnTypeDarkness
extends SpawnTypeBase {
    public boolean displayChatWarnings = true;
    public int lightLevelMax = 5;
    public int checkRate = 100;
    public double lowChance = 0.125;
    public double medChance = 0.25;
    public double hiChance = 0.5;
    public Map<EntityPlayer, Byte> darknessLevels = new HashMap<EntityPlayer, Byte>();

    public SpawnTypeDarkness(String typeName) {
        super(typeName);
        CustomSpawner.instance.updateSpawnTypes.add(this);
    }

    @Override
    public void loadFromConfig() {
        super.loadFromConfig();
        ConfigBase config = ConfigBase.getConfig(LycanitesMobs.group, "spawning");
        this.displayChatWarnings = config.getBool("Spawner Features", "Darkness Spawn Chat Warnings", this.displayChatWarnings, "Set to false to prevent the darkness warning messages from showing.");
        this.lightLevelMax = config.getInt("Spawner Features", "Darkness Spawn Highest Light Level", this.lightLevelMax, "The highest light level the Darkness spawn type will work in. 5 Is above ground in the overworld at night time. 0 is pitch black.");
        this.checkRate = config.getInt("Spawner Features", "Darkness Spawn Check Rate", this.checkRate, "The rate in ticks (20 ticks = 1 second) that the light level is checked, a higher rate will make things spawn much faster from the darkness.");
        this.lowChance = config.getDouble("Spawner Features", "Darkness Spawn Low Chance", this.lowChance, "The chance from 0.0-1.0 that a monster will spawn when in most dark light levels.");
        this.medChance = config.getDouble("Spawner Features", "Darkness Spawn Medium Chance", this.medChance, "The chance from 0.0-1.0 that a monster will spawn when in light level 1 (almost the darkest).");
        this.hiChance = config.getDouble("Spawner Features", "Darkness Spawn High Chance", this.hiChance, "The chance from 0.0-1.0 that a monster will spawn when in light level 0 (the darkest).");
    }

    @Override
    public boolean spawnMobs(long tick, World world, BlockPos pos, EntityPlayer player) {
        boolean isValidBlock;
        boolean spawned = false;
        BlockPos playerCoords = player.func_180425_c();
        IBlockState blockState = world.func_180495_p(playerCoords);
        Block block = blockState.func_177230_c();
        boolean bl = isValidBlock = block != null;
        if (isValidBlock) {
            boolean bl2 = isValidBlock = !blockState.func_185915_l();
        }
        if (isValidBlock) {
            boolean bl3 = isValidBlock = blockState.func_185904_a() != Material.field_151586_h;
        }
        if (!player.field_71075_bZ.field_75098_d && isValidBlock && tick % (long)this.checkRate == 0L && this.enabled && this.hasSpawns()) {
            int lightLevel = world.func_175699_k(playerCoords);
            byte darknessLevel = 0;
            if (this.darknessLevels.containsKey(player)) {
                darknessLevel = (byte)Math.max(0, Math.min(2, this.darknessLevels.get(player).byteValue()));
            }
            LycanitesMobs.printDebug("CustomSpawner", "Darkness Level Read: " + darknessLevel);
            if (lightLevel <= this.lightLevelMax) {
                double chance = this.lowChance;
                if (lightLevel <= 0) {
                    chance = this.hiChance;
                } else if (lightLevel == 1) {
                    chance = this.medChance;
                }
                float roll = player.func_70681_au().nextFloat();
                ExtendedWorld worldExt = ExtendedWorld.getForWorld(world);
                if (worldExt != null && "shadowgames".equalsIgnoreCase(worldExt.getWorldEventType())) {
                    roll /= 2.0f;
                }
                if (chance > (double)roll) {
                    if ((darknessLevel = (byte)(darknessLevel + 1)) == 1 && this.displayChatWarnings) {
                        String message = I18n.func_74838_a((String)"spawner.darkness.level1");
                        player.func_145747_a((ITextComponent)new TextComponentString(message));
                    } else if (darknessLevel == 2 && this.displayChatWarnings) {
                        String message = I18n.func_74838_a((String)"spawner.darkness.level2");
                        player.func_145747_a((ITextComponent)new TextComponentString(message));
                    } else if (darknessLevel == 3) {
                        if (this.displayChatWarnings) {
                            String message = I18n.func_74838_a((String)"spawner.darkness.level3");
                            player.func_145747_a((ITextComponent)new TextComponentString(message));
                        }
                        spawned = super.spawnMobs(tick, world, playerCoords, player);
                        darknessLevel = 0;
                    } else {
                        darknessLevel = 0;
                    }
                }
            } else if (darknessLevel > 0) {
                if (darknessLevel == 2 && this.displayChatWarnings) {
                    String message = I18n.func_74838_a((String)"spawner.darkness.level1.back");
                    player.func_145747_a((ITextComponent)new TextComponentString(message));
                }
                darknessLevel = (byte)(darknessLevel - 1);
            }
            this.darknessLevels.put(player, darknessLevel);
            LycanitesMobs.printDebug("CustomSpawner", "Darkness Level Write: " + darknessLevel);
        }
        return spawned;
    }

    @Override
    public boolean canSpawn(long tick, World world, BlockPos pos, int rank) {
        return true;
    }

    @Override
    public List<BlockPos> orderCoords(List<BlockPos> coords, BlockPos pos) {
        return this.orderCoordsCloseToFar(coords, pos);
    }
}

